// cron/notifyRenewals.js
import cron from 'node-cron';
import mongoose from 'mongoose';
import axios from 'axios';
import dotenv from 'dotenv';
import User from './models/User.js'; // your user model path

dotenv.config();

// Connect to MongoDB
await mongoose.connect(process.env.MONGO_URI);

// Your Telegram bot token and message function
const TELEGRAM_BOT_TOKEN = process.env.TELEGRAM_BOT_TOKEN;
const sendTelegramMessage = async (chatId, message) => {
  const url = `https://api.telegram.org/bot${TELEGRAM_BOT_TOKEN}/sendMessage`;
  await axios.post(url, {
    chat_id: chatId,
    text: message,
  });
};

// Cron job - every day at 00:00
cron.schedule('0 0 * * *', async () => {
  const today = new Date();
  const threeDaysLater = new Date(today);
  threeDaysLater.setDate(today.getDate() + 3);

  const usersToNotify = await User.find({
    renewalDate: {
      $gte: new Date(threeDaysLater.setHours(0, 0, 0, 0)),
      $lt: new Date(threeDaysLater.setHours(23, 59, 59, 999)),
    },
  });

  for (const user of usersToNotify) {
    const message = `Hi ${user.name}, your subscription will renew in 3 days. Please make sure your payment is updated.`;
    try {
      await sendTelegramMessage(user.telegramId, message);
      console.log(`Notification sent to ${user.name}`);
    } catch (error) {
      console.error(`Failed to send message to ${user.name}:`, error.message);
    }
  }
});
