import mongoose from 'mongoose';

const UserSchema = new mongoose.Schema({
  name: { type: String, required: true },
  telegramId: { type: String, required: true, unique: true },
  dateOfJoin: { type: Date, required: true },
  datePayment: { type: Date, required: true },
  paymentUrl: { type: String },
  amount: { type: Number, required: true },
  startPlanData: { type: Date },
  plan: {
    type: String,
    enum: ['monthly', 'quarterly', 'annually'],
    required: true
  },
  renewalDate: { type: Date }
}, { timestamps: true });

// Optional: Virtual for days until renewal
UserSchema.virtual('daysUntilRenewal').get(function() {
  if (!this.renewalDate) return null;
  const today = new Date();
  const diff = (this.renewalDate - today) / (1000 * 60 * 60 * 24);
  return Math.floor(diff);
});

UserSchema.set('toJSON', { virtuals: true });

export default mongoose.model('User', UserSchema);
