import axios from 'axios';

const BOT_TOKEN = process.env.TELEGRAM_BOT_TOKEN;
const BASE_URL = `https://api.telegram.org/bot${BOT_TOKEN}/sendMessage`;

export default async function sendTelegramNotification(chatId, message) {
  try {
    const response = await axios.post(BASE_URL, {
      chat_id: chatId,
      text: message,
      parse_mode: 'Markdown', // Optional: enables bold/italic in message
    });

    if (!response.data.ok) {
      throw new Error(`Telegram error: ${response.data.description}`);
    }

    console.log(`✅ Notification sent to chat ID: ${chatId}`);
  } catch (error) {
    const err = error.response?.data || error.message;
    console.error('❌ Telegram notification error:', err);
  }
}
